EvaluateSystemScript("time.js");
EvaluateSystemScript("colors.js");
EvaluateScript("update.js");
EvaluateScript("menus.js");
//EvaluateScript("MapEditor.js");
var SW = GetScreenWidth();
var SH = GetScreenHeight();
var mans = 3;
var score = 0;
var level = 1;
var time = 100;
var timing = true;
var atarifont = GetSystemFont();
var level_beat = false;
var speed = 5;
var maps = [];
var atarifont = LoadFont("atari_text.rfn");
var game_mode = "";
var collect_sound = LoadSound("collect.ogg");
var die_sound = LoadSound("die.ogg");
var forcefield_sound = LoadSound("forcefield.ogg");
var bg = LoadImage("background.png");
var secret_collect_img = LoadImage("secretcollect.png");
var dead = false;
var text_col = CreateColor(153,153,153);
var start_time = GetTime();
var dead_time = GetTime();
atarifont.setColorMask(text_col);
var dead_cols = [CreateColor(135,0,0,50), CreateColor(0,135,0,50), CreateColor(0,0,135,50),CreateColor(135,135,0,50),CreateColor(135,0,135,50),CreateColor(0,135,135,50),CreateColor(0,255,255,50)];
var dead_index = 0;
var picked_up_powerups = [];


function Update() {
	SetPersonSpeed("player", speed);
	if(timing && time>0) {
		if(start_time+900<=GetTime()) {
			start_time = GetTime();
			time-=5;
		}
	}
	if(time==0) {
		die_sound.play();
		if(mans==0) dead=true;
		else {
			mans--;
			time=100;
			ChangeMap(maps[level-1]);
		}
	}
}

function Render() {
	bg.blit(0,0);
	for(p=1;p<people.length;p++) {
		if(!IsIgnoringPersonObstructions(people[p])) {
			QueuePersonCommand(people[p],COMMAND_ANIMATE,true);
		}
		else {
			DestroyPerson(people[p]);
			people.splice(p,1)
		}
	}
	score_str = score.toString();
	while(score_str.length<8) score_str = "0"+score_str;
	atarifont.drawZoomedText(25,23,2,score_str);
	atarifont.drawZoomedText(170,23,2, "LEVEL "+level);
	atarifont.drawZoomedText(320,23,2, time);
	atarifont.drawZoomedText(420,23,2, "MANS:"+mans);
	if(level_beat) {
		collect_sound.play();
		DetachInput();
		picked_up_powerups = [];
		speed = 5;
		SetPersonDirection("secret", "found");
		if(level_beat_time+2000>GetTime()) {
			timing=false;
			QueuePersonCommand("secret",COMMAND_ANIMATE,true);
			secret_collect_img.blit(SW/2-secret_collect_img.width/2,SH-secret_collect_img.height);
		} else {
			SetPersonDirection("secret","north");
			collect_sound.stop();
			level_beat=false;
			score+=time;
			time=105;
			timing=true;
			AttachInput("player");
			if(level < maps.length) {
				level++
				ChangeMap(maps[level-1]);
			} else {
				ChangeMap(maps[level-1]);
			}
		}
	} else if(dead) {
		current_level = 0;
		time = 100;
		score = 0;
		timing = false;
		DetachInput();
		atarifont.drawZoomedText(SW/2-atarifont.getStringWidth("PRESS ANY KEY TO START")/2*3, SH-60,3, "PRESS ANY KEY TO START");
		ApplyColorMask(dead_cols[dead_index]);
		if(dead_time+2000<=GetTime()) {
			if(dead_index == dead_cols.length-1) dead_index=0;
			else dead_index++;
			dead_time = GetTime();
		}
		if(IsAnyKeyPressed()) {
			dead = false;
			timing = true;
			mans=3
			score=0;
			AttachInput("player");
			ChangeMap(maps[0]);
		}
	}
}

Array.prototype.filter = function(query, remove) {
	tmp = [];
	for(i=0;i<this.length;i++) {
		if(this[i].indexOf(query) > -1 && !remove) tmp.push(this[i]);
		else if(this[i].indexOf(query) == -1 && remove) tmp.push(this[i]);
	}
	return tmp;
}

function sortMaps(a, b){
	a=a.replace(mode+"-","");
	a=parseInt(a.replace(".rmp",""));
	b=b.replace(mode+"-","");
	b=parseInt(b.replace(".rmp",""));
	return (a-b); 
}

function game() {
	UpdateGame();
	mode = Menu();
	maps = GetFileList("maps").filter(mode,false);
	maps=maps.sort(sortMaps);
	CreatePerson("player","player.rss",false);
	AttachInput("player");
	start_time = GetTime();
	SetUpdateScript("Update()");
	SetRenderScript("Render()");
	SetPersonSpeed("player", speed);
	MapEngine(maps[0], 12);
}